/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.library.ninepatch;

import com.blamejared.jeitweaker.library.ninepatch.InvalidNinePatchDataException;
import com.blamejared.jeitweaker.library.ninepatch.NinePatchBehavior;

final class NinePatchRegion {
    private final NinePatchBehavior behavior;
    private final int beginning;
    private final int size;

    private NinePatchRegion(NinePatchBehavior behavior, int beginning, int size) {
        this.behavior = behavior;
        this.beginning = beginning;
        this.size = size;
    }

    static NinePatchRegion of(NinePatchBehavior behavior, int beginning, int size) throws InvalidNinePatchDataException {
        if (beginning < 0) {
            throw new InvalidNinePatchDataException("Unable to build nine-patch region for invalid beginning coordinate " + beginning);
        }
        if (size < 0) {
            throw new InvalidNinePatchDataException("Unable to build nine-patch region for invalid size " + size);
        }
        return new NinePatchRegion(behavior, beginning, size);
    }

    public NinePatchBehavior behavior() {
        return this.behavior;
    }

    public int beginning() {
        return this.beginning;
    }

    public int size() {
        return this.size;
    }
}

